import mx.rpc.Fault;

/**
 * mc.rpc.Fault subclass which is returned to a Fault event handler method when an XML-RPC
 * remote method call fails. Due to the limited information available in XML-RPC fault
 * messages (as defined in the XML-RPC standard), only the code and message properties are
 * set. 
 * 
 * @author H. Paul Robertson
 */
class com.probertson.xmlrpc.XmlRpcFault extends Fault
{

	#include "XmlRpcComponentVersion.as"

	/**
	 * Creates a new XmlRpcFault instance.
	 * 
	 * @param	code		The numeric error code returned by the server for the specific fault.
	 * @param	message		The error message returned by the server.
	 */
	public function XmlRpcFault(code:Number, message:String)
	{
		super(code.toString(), message, null, null);
	}
}