import com.probertson.xmlrpc.ServiceBase;
import com.probertson.xmlrpc.XmlRpcFault;

import mx.rpc.Fault;
import mx.rpc.FaultEvent;
import mx.rpc.Responder;
import mx.rpc.ResultEvent;

/**
 * The PendingCall is returned by any {@link com.probertson.xmlrpc.Service} remote method.
 * It does not contain the result of the remote method call; rather it provides a way
 * for the developer to access the result by assigning a value to the {@link com.probertson.xmlrpc.PendingCall#responder} property.
 * 
 * @author H. Paul Robertson
 */
class com.probertson.xmlrpc.PendingCall extends Object
{
	#include "XmlRpcComponentVersion.as"

	//
	// Private Fields
	//
	private var _service:ServiceBase;
	private var _methodName:String;
	private var _responder:Responder;


	//
	// Constructor
	//
	/**
	 * Creates a new PendingCall instance. Generally this will be called by {@link com.probertson.xmlrpc.Service}
	 * instances rather than developers creating PendingCall instances directly.
	 * @access	internal
	 * 
	 * @param	service		The {@link com.probertson.xmlrpc.ServiceBase} (service) to which the
	 * 						call is to be made.
	 * @param	methodName	The name of the remote method to call.
	 */
	public function PendingCall(service:ServiceBase, methodName:String)
	{
		super();
		_service = service;
		_methodName = methodName;
	}


	//
	// Public Properties
	//
	/**
	 * Gets or sets the mx.rpc.Responder instance which designates the mechanism for result
	 * or fault values to be returned.
	 */
	public function get responder():Responder
	{
		return _responder;
	}
	public function set responder(value:Responder):Void
	{
		_responder = value;
	}


	//
	// Public Properties
	//
	/**
	 * Gets the name of the remote method which was called and associated with this instance.
	 */
	public function get methodName():String
	{
		return _methodName;
	}


	//
	// Protected Methods
	//
	/**
	 * Channels remote method call results to the mx.rpc.Responder set as the {@link com.probertson.xmlrpc.PendingCall#responder}
	 * property of this instance.
	 * 
	 * @access	internal
	 */
	public function onResult(result:Object):Void
	{
		if (_responder != null)
		{
			_responder.onResult(new ResultEvent(result));
		}

//		if (_service.log != null)
//		{
//			_service.log.logInfo(_service.name + "." + _methodName + "() returned " + ObjectDumper.toString(result));
//		}
	}

	/**
	 * Channels remote method call errors to the mx.rpc.Responder set as the {@link com.probertson.xmlrpc.PendingCall#responder}
	 * property of this instance.
	 * 
	 * @access	internal
	 */
	public function onStatus(fault:XmlRpcFault):Void
	{
		if (_responder != null)
		{
			_responder.onFault(new FaultEvent(fault));
		}

//		if (_service.log != null)
//		{
//			_service.log.logDebug("Service invocation failed.");
//			_service.log.logDebug(_service.name + "." + _methodName + "() returned " + ObjectDumper.toString(status));
//		}
	}
}