/**
 * Interface that marks a class as an XML-RPC struct, allowing it to be passed as a parameter
 * to {@see com.probertson.xmlrpc.Service} method calls. In the XML-RPC standard, most simple types can be passed as
 * parameters to XML-RPC remote method calls. In addition, complex objects can be passed
 * as a (data only) XML-RPC struct. Developers who want to pass an XML-RPC struct to a remote method
 * should create a class which implements this interface. An instance of that class can then
 * be passed to the Service class method call, and it will be properly included in the XML-RPC remote method call
 * sent to the server.
 * @author H. Paul Robertson
 */
interface com.probertson.xmlrpc.IXmlRpcStruct
{
	/**
	 * Implementers should provide an implementation which returns an Array whose elements are
	 * String variables, containing the names of the properties of the class which should be
	 * included as properties of the XML-RPC struct that is sent to the remote method call.
	 * Implementing classes can contain other properties, variables, and methods which are not
	 * included in the returned Array, and they will be ignored by the serializer and will not
	 * be included in the struct.
	 */
	function getStructProperties():Array;
}