/**
 * Utility class with methods for manipulating urls.
 * 
 * @author H. Paul Robertson
 */
class com.probertson.utils.UrlUtility extends Object
{
	private function UrlUtility()
	{
	}


	//
	// Public Static Methods
	//
	/**
	 * Returns the protocol of the URL of the current .swf file.
	 * 
	 * @return	The protocol of the current .swf file
	 */
	public static function getHostProtocol():String
	{
		var rootUrl:String = _root._url;
		if (!isHttpUrl(rootUrl))
		{
			// this is an error: the current .swf wasn't loaded using an http url
			// TODO
			return null;
		}
		var isSecure:Boolean = (rootUrl.indexOf("https", 0) == 0);
		return (isSecure) ? "https://" : "http://";
	}

	/**
	 * Converts a url to a full url including protocol
	 * 
	 * @param	url		The url to modify
	 * @return	The url with the http(s):// protocol prepended, if it wasn't there already
	 */
	public static function getHttpUrl(url:String):String
	{
		if (!isHttpUrl(url))
		{
			return getHostProtocol() + url;
		}
		return url;
	}

	/**
	 * Checks whether the passed url already has the http(s):// prefix
	 * 
	 * @param	url		The url to be checked
	 * @return	whether or not the passed url has the http(s):// prefix
	 */
	public static function isHttpUrl(url:String):Boolean
	{
		return ((url.indexOf("http://") == 0) || (url.indexOf("https://") == 0));
	}
}