﻿import mx.rpc.Responder;
import mx.rpc.FaultEvent;
import mx.rpc.ResultEvent;

/**
 * An alternative to mx.rpc.RelayResponder, with stricter type safety and better scope
 * control because the result function and fault function are typed as Function
 * rather than String (as in the original).
 *
 * @author H. Paul Robertson
 */
class com.probertson.rpc.RelayResponder2 extends Object implements Responder
{
	private var __scopeObj:Object;
	private var __onFault:Function;
	private var __onResult:Function;

	/**
	 * Creates a RelayResponder2 instance.
	 * 
	 * @param	scopeObj	The object in whose scope the result and fault functions will be
	 * 						executed (the object that will be represented by "this" in those
	 * 						functions).
	 * @param	resultFunc	The function to be called when a remote method call returns a result.
	 * 						That function can accept a single mx.rpc.ResultEvent argument.
	 * @param	faultFunc	The function to be called when a remote method call raises an error.
	 * 						That function can accept a single mx.rpc.FaultEvent argument.
	 */
	public function RelayResponder2(scopeObj:Object, resultFunc:Function, faultFunc:Function)
	{
		super();
		__scopeObj = scopeObj;
		__onFault = faultFunc;
		__onResult = resultFunc;
	}

	/**
	 * Part of the mx.rpc.Responder implementation. This method will be called when a remote
	 * method call raises an error, and forwards that call on to the function specified in the
	 * constructor's faultFunc argument.
	 */
	public function onFault(fault:FaultEvent):Void
	{
		__onFault.call(__scopeObj, fault);
	}

	/**
	 * Part of the mx.rpc.Responder implementation. This method will be called when a remote
	 * method call successfully returns a result, and forwards that call on to the function specified in the
	 * constructor's resultFunc argument.
	 */
	public function onResult(result:ResultEvent):Void
	{
		__onResult.call(__scopeObj, result);
	}
}
