﻿import Error;

/**
 * An Error that is thrown when at least one argument passed to a method is null
 * but is not allowed to be null.
 * 
 * @author H. Paul Robertson
 */
class com.probertson.ArgumentNullException extends Error
{
	private var _argName:String;

	/**
	 * @param	argName		The name of the argument that received a null value.
	 * @param	message		A custom error message to be displayed. If message is null
	 * 						or an empty string ("") the default message is used.
	 */
	public function ArgumentNullException(argName:String, message:String)
	{
		super(message);
		_argName = (argName != undefined) ? argName : null;
	}

	/**
	 * Gets the name of the argument which received a null value.
	 */
	public function get argument():String
	{
		return (undefined == _argName || null == _argName) ? null : _argName;
	}

	/**
	 * Gets the error message associated with this instance. Overrides Error.message.
	 */
	public function get message():String
	{
		if (super.message != undefined && super.message != null && super.message != "")
		{
			return super.message;
		}
		if (_argName != null)
		{
			return "The parameter " + _argName + " cannot be a null reference.";
		}
		return "One or more parameters contained a null reference which is not allowed.";
	}

	/**
	 * Gets the name of this exception. Overrides Error.name.
	 */
	public function get name():String
	{
		return "ArgumentNullException";
	}
}