import com.probertson.xmlrpc.Service;
import com.probertson.xmlrpc.PendingCall;

import mx.rpc.FaultEvent;
import mx.rpc.RelayResponder;
import mx.rpc.ResultEvent;
import mx.data.binding.ObjectDumper;

class Samples.MathServiceTest
{
	private static var _instance:MathServiceTest;
	// use the second url to test for a 404 error fault
	private var _serviceUrl:String = "http://www.cookcomputing.com/xmlrpcsamples/math.rem";
	//private var _serviceUrl:String = "http://www.example.com/RPC2/";
	private var _service:Service;

	private function MathServiceTest()
	{
		_service = new Service(_serviceUrl, "math", null, null);
	}

	public function sum(a:Number, b:Number):Void
	{
		trace("calling MathServiceTest.sum(" + a.toString() + ", " + b.toString() + ")");
		var pendingCall:PendingCall = _service.Add(a, b);
		pendingCall.responder = new RelayResponder(this, "sumResult", "sumFault");
	}

	private function sumResult(e:ResultEvent):Void
	{
		trace("calling addResult(); result = " + e.result.toString());
	}

	private function sumFault(e:FaultEvent):Void
	{
		trace("calling addFault(); faultstring = " + e.fault.faultstring);
	}

	public function difference(a:Number, b:Number):Void
	{
		trace("calling MathServiceTest.difference(" + a.toString() + ", " + b.toString() + ")");
		var pendingCall:PendingCall = _service.Subtract(a, b);
		pendingCall.responder = new RelayResponder(this, "differenceResult", "differenceFault");
	}

	private function differenceResult(e:ResultEvent):Void
	{
		trace("calling differenceResult(); result = " + e.result.toString());
	}

	private function differenceFault(e:FaultEvent):Void
	{
		trace("calling differenceFault(); faultstring = " + e.fault.faultstring);
	}

	public function sumAndDifference(a:Number, b:Number):Void
	{
		trace("calling MathServiceTest.sumAndDifference(" + a.toString() + ", " + b.toString() + ")");
		var pendingCall:PendingCall = _service.SumAndDifference(a, b);
		pendingCall.responder = new RelayResponder(this, "sumAndDifferenceResult", "sumAndDifferenceFault");
	}

	private function sumAndDifferenceResult(e:ResultEvent):Void
	{
		trace("calling sumAndDifferenceResult(); result = " + ObjectDumper.toString(e.result));
	}

	private function sumAndDifferenceFault(e:FaultEvent):Void
	{
		trace("calling sumAndDifferenceFault(); faultstring = " + e.fault.faultstring);
	}

	public static function main():Void
	{
		_instance = new MathServiceTest();
		_instance.sum(-5, 5);
		_instance.difference(7, 5.291);
		_instance.sumAndDifference(7, 5);
	}
}