import Samples.MathServiceSubclassTest.IMathServiceListener;
import Samples.MathServiceSubclassTest.MathService;
import Samples.MathServiceSubclassTest.MathServiceEvent;
import com.probertson.xmlrpc.PendingCall;

import mx.rpc.FaultEvent;
import mx.rpc.RelayResponder;
import mx.rpc.ResultEvent;
/*import mx.data.binding.ObjectDumper;*/

class Samples.MathServiceSubclassTest.MathServiceSubclassTest implements IMathServiceListener
{
	private static var _instance:MathServiceSubclassTest;

	private var _service:MathService;

	public function MathServiceSubclassTest()
	{
		_service = new MathService();
	}

	public function sum(a:Number, b:Number):Void
	{
		trace("calling MathService.sum(" + a.toString() + ", " + b.toString() + ")");
		var pendingCall:PendingCall = _service.sum(a, b);
		pendingCall.responder = new RelayResponder(this, "sumResult", "sumFault");
	}

	private function sumResult(e:ResultEvent):Void
	{
		trace("calling sumResult(); result = " + e.result.toString());
	}

	private function sumFault(e:FaultEvent):Void
	{
		trace("calling sumFault(); faultstring = " + e.fault.faultstring);
	}

	public function difference(a:Number, b:Number):Void
	{
		trace("calling MathServiceSubclassTest.difference(" + a.toString() + ", " + b.toString() + ")");
		// subscribe to the service's events
		_service.addListener(this);
		_service.difference(a, b);
	}

	public function onDifference(e:MathServiceEvent):Void
	{
		trace("calling onDifference()");
		if (e.success)
		{
			trace("result = " + e.result.toString());
		}
		else
		{
			trace("call failed");
		}
		// stop listening to events from the service
		_service.removeListener(this);
	}


/*
	public function sumAndDifference(a:Number, b:Number):Void
	{
		trace("calling MathServiceTest.sumAndDifference(" + a.toString() + ", " + b.toString() + ")");
		var pendingCall:PendingCall = _service.SumAndDifference(a, b);
		pendingCall.responder = new RelayResponder(this, "sumAndDifferenceResult", "sumAndDifferenceFault");
	}

	private function onDifference(e:MathServiceEvent):Void
	{
		trace("calling sumAndDifferenceResult(); result = " + ObjectDumper.toString(e.result));
	}

	private function sumAndDifferenceFault(e:FaultEvent):Void
	{
		trace("calling sumAndDifferenceFault(); faultstring = " + e.fault.faultstring);
	}
*/


	public static function main():Void
	{
		_instance = new MathServiceSubclassTest();
		_instance.sum(-5, 5);
		_instance.difference(7, 5.173);
		//_instance.sumAndDifference(7, 5);
	}
}