import com.probertson.xmlrpc.PendingCall;
import com.probertson.xmlrpc.ServiceBase;

import mx.rpc.FaultEvent;
import mx.rpc.ResultEvent;

import com.probertson.rpc.RelayResponder2;

// Event Handling
import event.EventListenerList;
import Samples.MathServiceSubclassTest.MathServiceEvent;
import Samples.MathServiceSubclassTest.IMathServiceListener;


/**
 * This class is an example of a strongly-typed XMLRPC service class
 */
class Samples.MathServiceSubclassTest.MathService extends ServiceBase
{
	// use the second url to test for a 404 error fault
	private static var _serviceUrl:String = "http://www.cookcomputing.com/xmlrpcsamples/math.rem";
	//private static var _serviceUrl:String = "http://www.example.com/RPC2/";

	// array of listeners for this object
	private var _listeners:EventListenerList;

	// The class constructor must call the superclass constructor
	// passing the values (e.g. service url and service name
	public function MathService()
	{
		super(_serviceUrl, "math", null, null);
		_listeners = new EventListenerList();
		trace("instantiating MathService");
	}

	// Define your own methods which are wrappers for the XMLRPC service's methods
	// that you are implementing.
	// The method call will be asynchronous:
	// If you want to be able to return a result, you will need to either return a reference
	// to the PendingCall instance returned by ServiceBase.call(), or you will need to
	// provide your own custom events to notify other objects

	// This method uses the simplest approach -- it simply passes the PendingCall back
	// and lets whatever object called this method handle the response directly
	public function sum(a:Number, b:Number):PendingCall
	{
		return super.call("Add", a, b);
	}

	// This example uses a more complex approach.  The class exposes an event which is
	// triggered when the response is received.
	// For event handling this uses the Delegation Model described in Ch. 19
	// of Essential ActionScript 2.0 (Moock)
	public function difference(a:Number, b:Number):Void
	{
		var pendingCall:PendingCall = super.call("Subtract", a, b);
		pendingCall.responder = new RelayResponder2(this, onDifferenceResult, onDifferenceFault);
	}


	/////////////////////////////////////////////////////
	// Event Handling
	/////////////////////////////////////////////////////
	public function addListener(listener:IMathServiceListener):Void
	{
		_listeners.addObj(listener);
	}

	public function removeListener(listener:IMathServiceListener):Void
	{
		_listeners.removeObj(listener);
	}

	private function dispatch(success:Boolean, result:Number):Void
	{
		var listeners:Array = _listeners.getListeners();
		var numListeners:Number = listeners.length;
		var eventObj:MathServiceEvent = new MathServiceEvent(this, success, result);

		for (var i:Number = 0; i < numListeners; i++)
		{
			var listener:IMathServiceListener = IMathServiceListener(listeners[i]);
			listener.onDifference(eventObj);
		}
	}

	private function onDifferenceResult(e:ResultEvent):Void
	{
		var diffResult:Number = Number(e.result);
		dispatch(true, diffResult);
	}

	private function onDifferenceFault(e:FaultEvent):Void
	{
		dispatch(false, NaN);
	}
}