package views
{
	import caurina.transitions.Tweener;
	
	import events.FilterEvent;
	
	import flash.events.MouseEvent;
	import flash.filters.GlowFilter;
	import flash.utils.getDefinitionByName;
	
	import qnx.events.QNXApplicationEvent;
	import qnx.system.QNXApplication;
	import qnx.ui.core.Container;
	import qnx.ui.core.Containment;
	import qnx.ui.display.Image;
	
	[Event(name="filter", type="events.FilterEvent")]
	
	public class MenuContainer extends Container
	{
		public function MenuContainer()
		{
			containment = Containment.UNCONTAINED;
			createChildren();
			setSize(1024, 81);
			
			try
			{
//				QNXApplication.qnxApplication.addEventListener(QNXApplicationEvent.SWIPE_DOWN, swipeHandler);
				var q:QNXApplication;
				var c:Class = getDefinitionByName("qnx.system.QNXApplication") as Class;
				c.qnxApplication.addEventListener("swipeDown", swipeHandler);
				y = -82;
			}
			catch(error:VerifyError)
			{
				// do nothing
			}
		}
		
		
		// Variables
		private var imageType1:Image;
		private var imageType2:Image;
		private var imageType3:Image;
		private var currentImage:Image;
		private var glow:GlowFilter;
		private var isVisible:Boolean = false;

		
		// Methods
		private function createChildren():void
		{
			graphics.beginFill(0xDDDDDD, 0.9);
			graphics.drawRect(0, 0, 1024, 80);
			graphics.endFill();
			graphics.lineStyle(2, 0x000000);
			graphics.moveTo(0, 80);
			graphics.lineTo(1024, 80);
			graphics.lineStyle(2, 0x000000, 0.3);
			graphics.moveTo(0, 81);
			graphics.lineTo(1024, 81);
			
			if (!imageType1)
			{
				imageType1 = new Image();
				imageType1.setImage("assets/source1.png");
				imageType1.containment = Containment.UNCONTAINED;
				imageType1.setPosition(1024 / 4, 15);
				imageType1.addEventListener(MouseEvent.CLICK, imgClickHandler);
				addChild(imageType1);
			}
			
			if (!imageType2)
			{
				imageType2 = new Image();
				imageType2.setImage("assets/source2.png");
				imageType2.containment = Containment.UNCONTAINED;
				imageType2.setPosition(1024 / 2, 15);
				imageType2.addEventListener(MouseEvent.CLICK, imgClickHandler);
				addChild(imageType2);
			}
			
			if (!imageType3)
			{
				imageType3 = new Image();
				imageType3.setImage("assets/source3.png");
				imageType3.containment = Containment.UNCONTAINED;
				imageType3.setPosition(1024 * 3 / 4, 15);
				imageType3.addEventListener(MouseEvent.CLICK, imgClickHandler);
				addChild(imageType3);
			}
			
			if (!glow)
			{
				glow = new GlowFilter(0xAA3333, 0.8, 10, 10, 6);
			}
		}
		
		
		private function imgClickHandler(event:MouseEvent):void
		{
			if (currentImage)
				currentImage.filters = [];
			
			if (event.target == currentImage)
			{
				dispatchEvent(new FilterEvent(0));
				currentImage = null;
				return;
			}
			
			if (event.target == imageType1)
			{
				dispatchEvent(new FilterEvent(1));
			}
			else if (event.target == imageType2)
			{
				dispatchEvent(new FilterEvent(2));
			}
			else if (event.target == imageType3)
			{
				dispatchEvent(new FilterEvent(3));
			}
			
			currentImage = event.target as Image;
			currentImage.filters = [glow];
		}
		
		
		private function swipeHandler(event:QNXApplicationEvent):void
		{
			if (!isVisible)
				Tweener.addTween(this, {y: 0, time: 1.7});
			else
				Tweener.addTween(this, {y: -82, time: 1.7});
			
			isVisible = !isVisible;
		}
	}
}