package views
{
	import events.SiteChangeEvent;
	
	import qnx.ui.core.Container;
	import qnx.ui.core.SizeUnit;
	import qnx.ui.data.DataProvider;
	import qnx.ui.events.ListEvent;
	import qnx.ui.listClasses.List;
	import qnx.ui.listClasses.ListSelectionMode;
	
	import renderers.ListItemRenderer;
	
	import vo.SiteVO;
	
	[Event(name="siteChange", type="events.SiteChangeEvent")]
	
	public class ListContainer extends Container
	{
		public function ListContainer()
		{
			size = 224;
			sizeUnit = SizeUnit.PIXELS;
//			debugColor = 0xFF0000;
			createChildren();
		}
		
		
		// Variables
		
		private var list:List;
		
		
		// Methods
		
		private function createChildren():void
		{
			if (!list)
			{
				list = new List();
				list.columnWidth = 224;
				list.rowHeight = 60;
				list.size = 100;
				list.sizeUnit = SizeUnit.PERCENT;
				list.setSkin(ListItemRenderer);
				list.selectionMode = ListSelectionMode.SINGLE;
				list.allowDeselect = true;
				list.addEventListener(ListEvent.ITEM_CLICKED, listItemClickedHandler);
				addChild(list);
			}
		}
		
		
		public function setData(data:Array):void
		{
			list.dataProvider = new DataProvider(data);
		}
		
		
		private function listItemClickedHandler(event:ListEvent):void
		{
			dispatchEvent(new SiteChangeEvent(event.data.vo as SiteVO));
		}
	}
}