package views
{
	import flash.filters.GlowFilter;
	
	import qnx.ui.core.Container;
	import qnx.ui.core.ContainerAlign;
	import qnx.ui.display.Image;
	
	import renderers.SiteImage;
	
	public class ImageContainer extends Container
	{

		public function ImageContainer()
		{
//			debugColor = 0x0000FF;
			align = ContainerAlign.NEAR;
			createChildren();
		}
		
		
		// Variables
		private var image:Image;
		private var currentSiteImages:Array = [];
		private var glow:GlowFilter;
		private var currentSelected:SiteImage;
		
		
		// Methods
		
		public function setData(data:Array):void
		{
			var img:SiteImage;
			
			// Remove objects
			while (currentSiteImages.length > 0) 
			{
				img = currentSiteImages.pop();
				removeChild(img);
			}
			
			// Add objects
			for (var i:int = 0; i < data.length; i++)
			{
				img = new SiteImage();
				img.setData(data[i].vo);
				currentSiteImages.push(img);
				addChild(img);
			}
		}
		
		
		public function selectSite(selectedIndex:int):void
		{
			for (var i:int = 0; i < currentSiteImages.length; i++) 
			{
				if (currentSiteImages[i].data.index == selectedIndex)
				{
					selectSiteImage(currentSiteImages[i]);
					return;
				}
			}
		}
		
		
		private function createChildren():void
		{
			if (!image)
			{
				image = new Image();
				image.setImage("assets/area.jpg");
				addChild(image);
			}
			if (!glow)
			{
				glow = new GlowFilter(0xAA3333, 0.8, 10, 10, 6);
			}
		}
		
		
		private function selectSiteImage(site:SiteImage):void
		{
			if (currentSelected)
				currentSelected.filters = [];
			currentSelected = site;
			// Set the glow filter
			currentSelected.filters = [glow];
		}
	}
}