/*
Copyright (c) 2011 Renaun Erickson (http://renaun.com)

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
THE SOFTWARE.
*/
package renderers
{
	import flash.display.GradientType;
	import flash.display.Shape;
	import flash.filters.DropShadowFilter;
	import flash.text.TextFieldAutoSize;
	import flash.text.TextFormat;
	
	import qnx.ui.display.Image;
	import qnx.ui.listClasses.CellRenderer;
	import qnx.ui.skins.SkinStates;
	import qnx.ui.text.Label;
	
	import vo.SiteVO;
	
	public class ListItemRenderer extends CellRenderer
	{
		public function ListItemRenderer()
		{
			super();
		}
		
		
		protected var bg:Shape;
		protected var img:Image;
		protected var lblName:Label;
		protected var lblLocation:Label;
		
		
		override protected function init():void
		{
			bg = new Shape();
			addChild(bg);
			
			img = new Image();
			img.setPosition(4, 7);
			img.setSize(30, 41);
			addChild(img);
			
			var format:TextFormat = new TextFormat();
			format.color = 0x333333;
			format.size = 20;
			format.bold = true;
			
			lblName = new Label();
			lblName.format = format;
			lblName.x = 38;
			lblName.y = 5;
			lblName.autoSize = TextFieldAutoSize.LEFT;
			lblName.filters = [new DropShadowFilter(2)];
			addChild(lblName);
			
			lblLocation = new Label();
			format.size = 12;
			lblLocation.format = format;
			lblLocation.x = 38;
			lblLocation.y = 34;
			lblLocation.autoSize = TextFieldAutoSize.LEFT;
			addChild(lblLocation);
		}
		
		
		override protected function setState(state:String):void
		{
			super.setState(state);
			
			var alpha:Number = 0.5;
			if (state == SkinStates.SELECTED)
			{
				alpha = 0.3;
			}
			
			bg.graphics.clear();
			bg.graphics.beginGradientFill(GradientType.LINEAR, [0x000000, 0x000000], [alpha, alpha / 2], [0, 254]);
			bg.graphics.drawRect(0, 0, width, height);
			bg.graphics.endFill();
			bg.graphics.lineStyle(2, 0x222222);
			bg.graphics.moveTo(0, height - 1);
			bg.graphics.lineTo(width - 1, height - 1);
			bg.graphics.lineTo(width - 1, 0);
		}
		
		
		override public function set data(value:Object):void
		{
			super.data = value;
			updateCell();
		}
		
		
		private function updateCell():void
		{
			if (this.data && data.vo is SiteVO)
			{
				var siteVO:SiteVO = data.vo as SiteVO;
				img.setImage("assets/" + siteVO.icon);
				lblName.text = siteVO.name;
				lblLocation.text = "Location: " + siteVO.locationX + "/" + siteVO.locationY;
			}      
		}
	}
}