package
{
	import events.FilterEvent;
	import events.SiteChangeEvent;
	
	import flash.display.Sprite;
	import flash.display.StageAlign;
	import flash.display.StageScaleMode;
	import flash.events.Event;
	
	import qnx.ui.core.Container;
	import qnx.ui.core.ContainerFlow;
	import qnx.ui.theme.ThemeGlobals;
	
	import services.DataDelegate;
	
	import views.ImageContainer;
	import views.ListContainer;
	import views.MenuContainer;
	
	public class QNXDataExample extends Sprite
	{
		public function QNXDataExample()
		{
			super();
			stage.align = StageAlign.TOP_LEFT;
			stage.scaleMode = StageScaleMode.NO_SCALE;
			// Create layout
			createLayout();
			// Load data
			loadData();
		}
		
		
		//  Variables
		
		private var listContainer:ListContainer;
		private var imageContainer:ImageContainer;
		private var menuContainer:MenuContainer;
		
		private var dataDelegate:DataDelegate;
		
		
		//  Methods
		
		private function createLayout():void
		{
			
			var mainContainer:Container = new Container();
			mainContainer.flow = ContainerFlow.HORIZONTAL;
			
			listContainer = new ListContainer();
			listContainer.addEventListener(SiteChangeEvent.SITE_CHANGE, siteChangeHandler);
			mainContainer.addChild(listContainer);
			
			imageContainer = new ImageContainer();
			mainContainer.addChild(imageContainer);
			
			menuContainer = new MenuContainer();
			menuContainer.addEventListener(FilterEvent.FILTER, filterHandler);
			mainContainer.addChild(menuContainer);
			
			addChild(mainContainer);
			mainContainer.setSize(1024, 600);
		}
		
		
		private function loadData():void
		{
			if (!dataDelegate)
			{
				dataDelegate = new DataDelegate();
				dataDelegate.addEventListener(Event.COMPLETE, loadedHandler);
			}
			dataDelegate.load();
		}		
		
		
		private function loadedHandler(event:Event):void
		{
			// Pass data to child containers
			listContainer.setData(dataDelegate.currentData);
			imageContainer.setData(dataDelegate.currentData);
		}
		
		
		private function siteChangeHandler(event:SiteChangeEvent):void
		{
			imageContainer.selectSite(event.site.index);
		}
		
		
		private function filterHandler(event:FilterEvent):void
		{
			if (event.filterType > 0)
			{
				var filterData:Array = [];
				for (var i:int = 0; i < dataDelegate.currentData.length; i++) 
				{
					var item:Object = dataDelegate.currentData[i];
					if (item.vo.type == event.filterType)
					{
						item.vo.index = filterData.length;
						filterData.push(item);
					}
				}
				
				listContainer.setData(filterData);
				imageContainer.setData(filterData);
			}
			else
			{
				listContainer.setData(dataDelegate.currentData);
				imageContainer.setData(dataDelegate.currentData);
			}
		}
	}
}