﻿package 
{
	import flash.display.BitmapData;
    import flash.display.Sprite;
    import flash.display.StageAlign;
	import flash.display.StageScaleMode;
	import flash.events.ErrorEvent;
	import flash.events.Event;
	import flash.events.MouseEvent;
	import flash.media.CameraRoll;
	import flash.text.TextField;

	// This is the document class for the FLA
    public class TypeSnap extends Sprite
    {        
        public function TypeSnap()
        {
			addEventListener(Event.ADDED_TO_STAGE, this_addedToStage);
		}
		
		// Objects on the FLA's stage
		public var cameraBtn:Sprite;
		// This is an "input" text field. When the user taps that text field,
		// the iPhone keyboard opens automatically (no code necessary for keyboard
		// interaction)
		public var inputTxt:TextField;
		// This is a "dynamic" text field, for writing out status messages.
		public var outputTxt:TextField;
		
		
		private function this_addedToStage(event:Event):void
		{
			removeEventListener(Event.ADDED_TO_STAGE, this_addedToStage);
			
            stage.scaleMode = StageScaleMode.NO_SCALE;
            stage.align = StageAlign.TOP_LEFT;
			
			cameraBtn.addEventListener(MouseEvent.CLICK, cameraBtn_click);
        }
		
		
		// called when the button is clicked
		private function cameraBtn_click(event:MouseEvent):void
		{
			// set the status message to "saving" while the asynchronous save operation
			// is running
			outputTxt.text = "Saving...";
			
			// Check whether the current platform supports saving to camera roll
			if (CameraRoll.supportsAddBitmapData)
			{
				// Create the CameraRoll object
				var cameraRoll:CameraRoll = new CameraRoll();
				
				// register event listeners for saving images and trapping errors
				cameraRoll.addEventListener(ErrorEvent.ERROR, cameraRoll_error);
				cameraRoll.addEventListener(Event.COMPLETE, cameraRoll_complete);
				
				// Create a BitmapData object (a screen capture of the input text field)
				var bitmapData:BitmapData = new BitmapData(inputTxt.width, inputTxt.height);
				bitmapData.draw(inputTxt);
				// Start saving the BitmapData data to the camera roll image
				cameraRoll.addBitmapData(bitmapData);
			}
			else
			{
				// do nothing
			}
		}
		
		// event handlers for the save to camera roll operation
		private function cameraRoll_error(event:ErrorEvent):void
		{
			outputTxt.text = "Error saving note."
		}
		
		private function cameraRoll_complete(event:Event):void
		{
			outputTxt.text = "Note saved.";
		}
    }
}