﻿package 
{
    import flash.display.Sprite;
    import flash.display.StageAlign;
	import flash.display.StageOrientation;
    import flash.display.StageScaleMode;
	import flash.events.Event;
	import flash.events.StageOrientationEvent;
	import flash.events.TouchEvent;

	// This is the document class for the FLA
    public class ThisSideUp extends Sprite
    {        
        public function ThisSideUp()
        {
			addEventListener(Event.ADDED_TO_STAGE, this_addedToStage);
		}
		
		// block is an object on the FLA's stage
		public var block:Sprite;
		
		// this is used to keep track of whether we're letting the stage auto-rotate or not
		private var autoOrient:Boolean = true;
		
		
		private function this_addedToStage(event:Event):void
		{
			removeEventListener(Event.ADDED_TO_STAGE, this_addedToStage);
			
			// Normally the stage size would stay the same, and when it auto-rotates it would
			// stretch or shrink to fit the entire stage on the screen even if it's rotated.
			// These two lines override that behavior so the stage resizes to the new stage size 
			// instead of scaling -- but then you have to reposition stage content manually.
            stage.scaleMode = StageScaleMode.NO_SCALE;
            stage.align = StageAlign.TOP_LEFT;
			
			// This event is dispatched after the device has been rotated, but before the 
			// auto-stage rotation has actually happened. (The "change" event is called after
			// rotation has actually happened.)
			stage.addEventListener(StageOrientationEvent.ORIENTATION_CHANGING, stage_orientationChanging);
			
			// Just for fun this uses the touchTap event instead of the click event, but in 
			// this case the behavior is identical since the code doesn't care about multitouch
			block.addEventListener(TouchEvent.TOUCH_TAP, block_touchTap);
        }
		
		
		// Called right before the stage is rotated automatically when the device is rotated
		private function stage_orientationChanging(event:StageOrientationEvent):void
		{
			// if the user has tapped the block (to override auto rotation)
			// call preventDefault(), which forces rotation to not happen.
			if (!autoOrient)
			{
				event.preventDefault();
				return;
			}
			
			// if we're using normal rotation, figure out the orientation that 
			// the stage is about to have, and center the block based on that
			// orientation.
			var w:Number;
			var h:Number;
			switch (event.afterOrientation)
			{
				case StageOrientation.DEFAULT:
				case StageOrientation.UPSIDE_DOWN:
					w = 320;
					h = 480;
					break;
				case StageOrientation.ROTATED_LEFT:
				case StageOrientation.ROTATED_RIGHT:
					w = 480;
					h = 320;
					break;
			}
			block.x = (w - block.width) / 2;
			block.y = (h - block.height) / 2;
		}
		
		
		// Tapping the block toggles the auto-rotation behavior
		private function block_touchTap(event:TouchEvent):void
		{
			autoOrient = !autoOrient;
		}
    }
}