﻿package 
{
	import flash.events.Event;
	import flash.events.TransformGestureEvent;
	import flash.geom.Matrix;
	import flash.ui.Multitouch;
	import flash.ui.MultitouchInputMode;
	import flash.display.Sprite;
	
	// This is the document class for the FLA
	public class Rotate extends Sprite
	{
		public function Rotate()
		{
			addEventListener(Event.ADDED_TO_STAGE, this_addedToStage);
		}
		
		// This is just a MovieClip instance on the FLA's stage
		public var logo:Sprite;
		
		
		private function this_addedToStage(event:Event):void
		{
			removeEventListener(Event.ADDED_TO_STAGE, this_addedToStage);
			
			// set the input mode to gesture (as opposed to raw touch events)
			Multitouch.inputMode = MultitouchInputMode.GESTURE;
			
			logo.cacheAsBitmap = true;
			logo.cacheAsBitmapMatrix = new Matrix();
			
			// Register for three of the available gestures: zoom (pinch), rotate, and pan.
			// These are added to the stage so the event is triggered even when the content 
			// is too small to receive the gestures.
			stage.addEventListener(TransformGestureEvent.GESTURE_ZOOM, stage_zoom);
			stage.addEventListener(TransformGestureEvent.GESTURE_ROTATE, stage_rotate);
			stage.addEventListener(TransformGestureEvent.GESTURE_PAN, stage_pan);
		}
		
		
		// event handler for the zoom (pinch) gesture -- it simply scales the logo
		private function stage_zoom(event:TransformGestureEvent):void
		{
			logo.scaleX *= event.scaleX;
			logo.scaleY *= event.scaleY;
		}
		
		
		// event handler for the rotate gesture -- it alters the logo's rotation
		function stage_rotate(event:TransformGestureEvent):void
		{
			logo.rotation += event.rotation;
		}
		
		
		// event handler for the pan gesture -- it moves the logo by the offset amount
		function stage_pan(event:TransformGestureEvent):void
		{
			logo.x += event.offsetX;
			logo.y += event.offsetY;
		}
	}
}